package gov.va.med.mhv.rxrefill.web.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.event.data.SortEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.rxrefill.web.util.RxMessagesUtil;
import gov.va.med.mhv.rxrefill.dto.PrescriptionDTO;
import gov.va.med.mhv.rxrefill.exception.MHVRuntimeException;
import gov.va.med.mhv.rxrefill.web.util.PrescriptionsTrackingComparator;

@ManagedBean
@Component
@Scope("session")
public class PrescriptionsTrackingController extends AbstractRxController {

	private static final long serialVersionUID = -7198958966081915537L;

	private static Logger log = LogManager.getLogger(PrescriptionsHistoryController.class);

	private DataTable historyRxTable;
	private PrescriptionDTO selectedPrescription;
	private boolean hasRefillableRx = false;
	
	private List<PrescriptionDTO> historicalPrescriptions = null;
	private List<PrescriptionDTO> filteredHistoricalPrescriptions = null;
	private List<PrescriptionDTO> allPrescriptions = null;


	public static final String TRACKING_INFORMATION_DETAIL_PAGE="prescriptionsTrackingInformationDetail";
	public static final String IMAGE_PAGE="trackingMedicationImagePage";
	public static final String TRACKING_CARRIER_LANDING_PAGE="trackingCarrierLandingPage";
	
	@Autowired
	private RxMessagesUtil rxMessagesUtil;

	public String acceptAgreement() {
		if (log.isDebugEnabled()) {
			log.debug("inside acceptAgreement.......");
		}
		declineMessage = null;
		newSaveProfileDto=this.userProfileDto;
		try {
			if (null != newSaveProfileDto && null != newSaveProfileDto.getId()) {
				newSaveProfileDto.setRxAgreementDate(new Date(System.currentTimeMillis()));
				newSaveProfileDto.setRxAgreementSigned(new Boolean(true));

				// save user profile
				saveUserProfile(newSaveProfileDto);
			}
		} catch (MHVException e) {
			throw new MHVRuntimeException("Error in accepting Rx agreement from tracking pages: " + e.getMessage());
		}


		return "prescriptionsTrackingSummary";
	}

	@Override
	protected void loadEntities(UserProfileDTO userProfileDto) {
		// TODO Auto-generated method stub

	}

	@Override
	protected List<PrescriptionDTO> lookupPrescriptions(Long userProfileId) {
		ResponseUtil response = null;
		ResponseUtil<List<PrescriptionDTO>> prescriptionResponse = null;
		List<PrescriptionDTO> historicalPrescriptions = null;		

		try {

			prescriptionResponse = getRxRefillServiceServiceProxy().getPrescriptionsHistory(userProfileId);
			
			processResponseMessages(userProfileId, prescriptionResponse);
			
			if(log.isDebugEnabled()){
				log.debug("response.getFailureMessage()" + prescriptionResponse.getFailureMessage());
			}

	        if (!prescriptionResponse.isFailure()) {
	        	historicalPrescriptions = (List<PrescriptionDTO>) prescriptionResponse.getPojoObject();
			}
			
			if (log.isDebugEnabled()) {
				log.debug("historicalPrescriptions count : "
						+ ((null != historicalPrescriptions) ? historicalPrescriptions.size() : 0));
			}

		} catch (Exception e) {
			log.error("Error in fetching prescription histories", e);
			throw new MHVRuntimeException("Error in fetching prescription histories", e);
		}		
		
		try {
			allPrescriptions = getRxRefillServiceServiceProxy().getAllPrescriptions(userProfileId);
			if (log.isDebugEnabled()) {
				log.debug("allPrescriptions count : "
						+ ((null != allPrescriptions) ? allPrescriptions.size() : 0));
			}

		} catch (Exception e) {
			log.error("Error in fetching all Prescriptions", e);
			throw new MHVRuntimeException("Error in fetching all Prescriptions", e);
		}

		filteredHistoricalPrescriptions= filterPrescriptions(historicalPrescriptions);

		return historicalPrescriptions;
	}

	public void processResponseMessages(Long userProfileId, ResponseUtil<List<PrescriptionDTO>> prescriptionResponse) {
		List<PrescriptionDTO> prescriptions = null;
		
		try {

			if(log.isDebugEnabled()){
				log.debug("response.getFailureMessage()" + prescriptionResponse.getFailureMessage());
			}

	        if (!prescriptionResponse.isFailure()) {
	        	prescriptions = (List<PrescriptionDTO>) prescriptionResponse.getPojoObject();
			}
			
			String facilityNames = "";
			ArrayList<String> facilityNamesList = new ArrayList<String>();

			if (null != prescriptions && prescriptions.size() > 0) {
				for (PrescriptionDTO rx : prescriptions) {
					facilityNamesList.add(rx.getFactilityName());
				}
			}
			// convert to hashlist and copy back to arraylist to remove duplicates
			HashSet hs = new HashSet();
			hs.addAll(facilityNamesList);
			facilityNamesList.clear();
			facilityNamesList.addAll(hs);
			Collections.sort(facilityNamesList);

			Iterator<String> itr = facilityNamesList.iterator();
			int i=0;
			while(itr.hasNext()){
				facilityNames = facilityNames+","+itr.next();
			}
			
			if(log.isDebugEnabled()){
				log.debug("response.getFailureMessage()" + prescriptionResponse.getFailureMessage());
			}
			if(prescriptionResponse.getFailureMessage() != null) {
				FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, prescriptionResponse.getFailureMessage(), prescriptionResponse.getFailureMessage()));
			}

			//FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, prescriptionResponse.getFailureMessage(), prescriptionResponse.getFailureMessage()));

			Map<String, String> infoMessages = prescriptionResponse.getInfoMessages();
			if (null != infoMessages && infoMessages.size() > 0) {
				if(log.isDebugEnabled()){
					log.debug("infoSize : " + infoMessages.size());
				}
				Set set = infoMessages.entrySet();
				Iterator iterator = set.iterator();
		        while(iterator.hasNext()) {
		             Map.Entry me = (Map.Entry)iterator.next();
		 			if(log.isDebugEnabled()){
		 				log.debug("Key is: "+ me.getKey() + "& Value is: "+me.getValue());
		 			}
		 			System.out.println("Key is: "+ me.getKey() + "& Value is: "+me.getValue());
		 			 //Keys are - rxrequestvistaservice.messaging.error, rxrequestvistaservice.status.error, rxrequestvistaservice.unexpected.error
		             //FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, (String) me.getValue(), (String) me.getValue()));
		             if (me.getKey().toString().contains(".error")) {
		            	 //String infoMessage = String.format(rxMessagesUtil.getErrorVistaSystemfailure(),selectedRxRefillFacilityNames.substring(1));  // Substring Removes extra , in the front
		            	 String selectedRxRefillFacilityName = (String) me.getValue();
		            	 String infoMessage = String.format(rxMessagesUtil.getErrorVistaSystemfailure(),selectedRxRefillFacilityName.substring(selectedRxRefillFacilityName.indexOf("null,")+5));  
		            	 FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, infoMessage, infoMessage));
		            	 messageSeverity = "INFO";
		             }
		             else if (me.getKey().toString().contains("maxExceeded")) {
		            	 //String infoMessage = String.format(rxMessagesUtil.getErrorVistaSystemfailure(),selectedRxRefillFacilityNames.substring(1));  // Substring Removes extra , in the front
		            	 String selectedRxRefillFacilityName = (String) me.getValue();
		            	 FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, rxMessagesUtil.getTrackingerrorMaxRefreshSystemfailure(), rxMessagesUtil.getTrackingerrorMaxRefreshSystemfailure()));
		            	 messageSeverity = "INFO";
		             }
		        }
			}

		} catch (Exception e) {
			log.error("Error in processing response messages <<<" + userProfileId +">>>", e);
			throw new MHVRuntimeException("Error in fetching active prescriptions", e);
		}
	}


	
	private List<PrescriptionDTO> filterPrescriptions(List<PrescriptionDTO> historicalPrescriptions) {
		List<PrescriptionDTO> filteredList = new ArrayList<PrescriptionDTO>();

		if (historicalPrescriptions != null) {
			for (PrescriptionDTO dto : historicalPrescriptions) {
				if (dto.isTracking()) {
					filteredList.add(dto);
				}

			}
		}
		if(filteredList != null){
		   Collections.sort(filteredList, new PrescriptionsTrackingComparator());
		}
		return filteredList;
	}


	@Override
	public String trackDelivery(PrescriptionDTO prescriptionDTO) {
		selectedPrescription = prescriptionDTO;
		setImagePage("trackingMedicationImagePage");
		return "prescriptionsTrackingInformationDetail";
	}

	public String refillPrescriptionsSummaryPrint() {
		//setHistoryRxTable((DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("prescriptionsTrackingForm:prescTrackList"));
		return "refillPrescriptionsSummaryPrint";
	}

	
	public String showDetail(PrescriptionDTO prescriptionDTO) {
		selectedPrescription = prescriptionDTO;
		return "prescriptionsTrackingDetail";
	}

	public PrescriptionDTO getSelectedPrescription() {
		return selectedPrescription;
	}

	public void setSelectedPrescription(PrescriptionDTO selectedPrescription) {
		this.selectedPrescription = selectedPrescription;
	}

	public boolean isHasRefillableRx() {
		return hasRefillableRx;
	}

	public void setHasRefillableRx(boolean hasRefillableRx) {
		this.hasRefillableRx = hasRefillableRx;
	}


	@Override
	protected void saveSortInfo() {
		// TODO Auto-generated method stub
		historyRxTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("prescriptionsTrackingForm:prescTrackList");
		if(!FacesContext.getCurrentInstance().isPostback()){
			setRowsPerPage(10);
		}else {
			if(sortColumn != null && sortBy != null){
				historyRxTable.setValueExpression("sortBy", sortColumn);
				historyRxTable.setSortOrder(sortBy);
				
			} 
		}
			
	}
	
	public void onSort(SortEvent event){
		sortColumn=event.getSortColumn().getValueExpression("sortBy");
		sortBy=event.isAscending()?"ascending":"descending";
	}

	public DataTable getHistoryRxTable() {
		return historyRxTable;
	}

	public void setHistoryRxTable(DataTable historyRxTable) {
		this.historyRxTable = historyRxTable;
	}
	
	
	@Override
	public String trackingWarningPage() {
		return TRACKING_CARRIER_LANDING_PAGE;
	}

	public List<PrescriptionDTO> getPrescriptions() {
		return historicalPrescriptions;
	}

	public void setPrescriptions(List<PrescriptionDTO> prescriptions) {
		this.historicalPrescriptions = prescriptions;
	}

	public List<PrescriptionDTO> getAllPrescriptions() {
		return allPrescriptions;
	}

	public void setAllPrescriptions(List<PrescriptionDTO> allPrescriptions) {
		this.allPrescriptions = allPrescriptions;
	}

	public List<PrescriptionDTO> getFilteredHistoricalPrescriptions() {
		return filteredHistoricalPrescriptions;
	}

	public void setFilteredHistoricalPrescriptions(
			List<PrescriptionDTO> filteredHistoricalPrescriptions) {
		this.filteredHistoricalPrescriptions = filteredHistoricalPrescriptions;
	}


}
